function  [SIFTpack  Indexes]= SIFTpack4set(SIFTset,SIFTpackInit)
% INPUT:
%SIFTset - a set of SIFTs
%SIFTpackInit - initial SIFTpack
%OUTPUT: 
%SIFTpack
%Indexes - belonging of each SIFT inside the SIFTpack in a column stack
%numbering

PatchSize=4;
LUT = zeros(128,1);
LUT(1:16) = [1 33 65 97 9 41 73 105 17 49 81 113 25 57 89 121]';
for n =2:8
    LUT((n-1)*16+1:n*16) = LUT(1:16) + n-1;
end
SIFTset = SIFTset(LUT,:);



NumOfIters = 10;
thresh = 1e-6;
[SIFTpackSizeI, SIFTpackSizeJ, ~] = size(SIFTpackInit);
 Dictionary = extractPatches3d(SIFTpackInit,PatchSize);
nPatches = size(SIFTset,2); 
SIFTpack = SIFTpackInit;
SIFTpackOld = SIFTpack;
nWords =SIFTpackSizeI*SIFTpackSizeJ;
Indexes = zeros(nPatches,1);
ErrFun=zeros(2*NumOfIters,1);
SIFTpackError=zeros(NumOfIters,1);

patchsNormSqr = sum(SIFTset.^2);
PatchNormSqrMat = repmat(patchsNormSqr,[nWords 1]);

for i = 1:NumOfIters
    disp(['iteration number: ',num2str(i)]);
    DicNormSqr = sum(Dictionary.^2);
    PatchDict = Dictionary'*SIFTset;
    DistsSqrMat = PatchNormSqrMat + bsxfun(@minus,DicNormSqr',2*PatchDict);
    [errEachP minIdxs] = min(DistsSqrMat);
    Indexes = minIdxs';
    ErrFun(2*i-1) = sum(errEachP);
    SIFTpackNew = SIFTpackUpdate(SIFTset,int32(Indexes),SIFTpackSizeI ,SIFTpackSizeJ);
    SIFTpack(SIFTpackNew~=0) = SIFTpackNew(SIFTpackNew~=0); %%%%filling hole with the previous iteration


    Dictionary = extractPatches3d(SIFTpack,PatchSize);
    err = SIFTset - Dictionary(:,Indexes);
    errEachPold = sum(err.^2);
    ErrFun(2*i) = sum(errEachPold);
    SIFTpackError(i) = sum( sum ( sum((SIFTpackOld - SIFTpack).^2) ) );
    if (SIFTpackError(i) < thresh)
        ErrFun = ErrFun(1:2*i);
        break;
        
    end
    SIFTpackOld = SIFTpack;
   
end

% 
% figure
% plot(ErrFun);



function patches = extractPatches3d(Im ,Psize)
%extracts patches from 3 dimentional image, the size of the patches is
%[Psize Psize depth] and it returns them in column stack. Patches near the
%end of the image are tajen in a cycle way

[M N depth] = size(Im);
Im = [Im Im(:,1:Psize-1,:)];
Im = [Im ; Im(1:Psize-1,:,:)];
patches = zeros(Psize^2*depth,M*N);
for d=1:depth
        patches((d-1)*Psize^2+1:d*Psize^2,:) = im2col((Im(:,:,d)),[Psize Psize]);     
end
    
