% This is an example of how to use our functions. 
% We show an example of how to create a dense-SIFTpack, how to create a
% SIFTpack from SIFTs taken densely from an image and how to create a
% general SIFTpack. 
% All of our functions are implemented in C and compiled to "mex" files for
% running on matlab. There are compiled "mex" files for windows and linux
% platforms, 64bit.

clear all
close all

load('SIFTs') % we saved a set of SIFTs taken densely each 4 pixels (step) from the image "Avatar FULL 1080p 00402.jpg"
              % the size of the dense SIFTpack is SxXSyX8
Sx = 480;
Sy = 200;
step = 4; 

%% creating a Dense SIFTpack: by only averaging the overlaps
DenseSIFTpack=CreateDSIFTpack(DESCR,step,Sy,Sx);

%showing the SIFTpack
I = imread('Avatar FULL 1080p 00402.jpg');
figure;
subplot(3,3,5);
imshow(I);
subplot(3,3,1);
imshow(DenseSIFTpack(:,:,1),[]);
subplot(3,3,2);
imshow(DenseSIFTpack(:,:,2),[]);
subplot(3,3,3);
imshow(DenseSIFTpack(:,:,3),[]);
subplot(3,3,4);
imshow(DenseSIFTpack(:,:,4),[]);
subplot(3,3,6);
imshow(DenseSIFTpack(:,:,5),[]);
subplot(3,3,7);
imshow(DenseSIFTpack(:,:,6),[]);
subplot(3,3,8);
imshow(DenseSIFTpack(:,:,7),[]);
subplot(3,3,9);
imshow(DenseSIFTpack(:,:,8),[]);
%% creating a more compact SIFTpack for Dense SIFTs of an image (SIFTpack of the size 40x40)
% also possible is to resize gradually
C=8;
[Ms Ns ,~] = size(DenseSIFTpack);
firstLevel = imresize(DenseSIFTpack(:,:,1),[40 40],'bilinear');
EpitomeInit = zeros(size(firstLevel,1),size(firstLevel,2), C);
EpitomeInit(:,:,1) = firstLevel;
for c = 2:C
    EpitomeInit(:,:,c) = imresize(DenseSIFTpack(:,:,c),[40 40],'bilinear');
end

[SIFTpackSmall NNF]=CreateSIFTpackOfImage(DenseSIFTpack,EpitomeInit,10);

%% creating a SIFTpack from a set of SIFTs (generally taken from many images)
% note: large amount of memory is consumed
[SIFTpack  Indexes] = SIFTpack4set(DESCR,EpitomeInit);
