
#include "mex.h"


/*******************************************************************************/
/* mexFUNCTION - gateway routine for use with MATLAB                           */
/* Calculates Dense-SIFTpack         */
/*******************************************************************************/
void mexFunction(int nout, mxArray *pout[], int nin, const mxArray *pin[]) {
	///check input
	if (nin < 4) { mexErrMsgTxt("Mex error: SIFTpack called with < 4 input arguments!"); }

	int num_of_colors = 8;
	const mxArray *Descrs = pin[0];	
	const int scale = int(mxGetScalar(pin[1]));	
	const int Sy = int(mxGetScalar(pin[2]));	//SIFTpack size
	const int Sx = int(mxGetScalar(pin[3]));


	if ( !mxIsDouble(Descrs) ){ 
		mexErrMsgTxt("Mex error: Input Descriptors are not double!");
	}
//input parsing
	const int dim = mxGetDimensions(Descrs)[0];
	const int nDescr = mxGetDimensions(Descrs)[1];
	double *descrs =(double*) mxGetData(Descrs);
	if ( nDescr!=(Sx-3)*(Sy-3) ){ 
		mexErrMsgTxt("Mex error: number of descriptors doesn't fit the SIFTpack size!");
	}

//output
	mwSize dims[3] = { Sy, Sx, num_of_colors };
	mxArray *SIFTpack = mxCreateNumericArray(3, dims, mxDOUBLE_CLASS, mxREAL);
	double *siftpack = (double *) mxGetData(SIFTpack);

	int* counts = new int [Sy*Sx];
//initialization
	for (int i = 0; i < Sy*Sx; ++i)
		counts[i] = 0;
	for (int i = 0; i < Sy*Sx*num_of_colors; ++i)
		siftpack[i] = 0;


	for (int x=0; x <(Sx-3); ++x){
		for (int y=0; y <(Sy-3); ++y){	
			for (int i=0; i<4;++i){ //c=0;
					for (int j=0; j<4;++j){
						siftpack[Sy*(x+i)+y+j] +=descrs[num_of_colors*(j*4+i)];
						++counts[Sy*(x+i)+y+j];
					}
				}

			for (int c=1; c<num_of_colors; ++c){//c>0
				int stLayer = c*Sx*Sy;
				for (int i=0; i<4;++i){
					for (int j=0; j<4;++j){
						siftpack[stLayer+Sy*(x+i)+y+j] +=descrs[c+num_of_colors*(j*4+i)];
						
					}
				}
			}
			descrs+=dim;
		}
	} 

	for (int c=0; c<num_of_colors; ++c){
				int stLayer = c*Sx*Sy;
				for (int i = 0; i < Sy*Sx; ++i){
					siftpack[stLayer+i] /= counts[i];
				}
	}
 pout[0]=SIFTpack;
	
} // end mexFunction

